<?xml version="1.0" encoding="utf-8"?>
<!-- CityGML Version No. 1.1.0, July 2011 -->
<!-- CityGML - GML 3.1.1 application schema for 3D city models -->
<!-- International encoding standard of the Open Geospatial Consortium, see http://www.opengeospatial.org/standards/citygml -->
<!-- Jointly developed by the Special Interest Group 3D (SIG 3D) of GDI-DE, see http://www.sig3d.org               -->
<!-- For further information see: http://www.citygml.org -->
<CityModel xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.opengis.net/citygml/1.1"
	xmlns:xAL="urn:oasis:names:tc:ciq:xsdschema:xAL:2.0" xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:gml="http://www.opengis.net/gml" xmlns:dem="http://www.opengis.net/citygml/relief/1.1"
	xmlns:bldg="http://www.opengis.net/citygml/building/1.1" xmlns:app="http://www.opengis.net/citygml/appearance/1.1"
	xsi:schemaLocation="http://www.opengis.net/citygml/building/1.1 ../../CityGML/building.xsd
	http://www.opengis.net/citygml/relief/1.1 ../../CityGML/relief.xsd
	http://www.opengis.net/citygml/appearance/1.1 ../../CityGML/appearance.xsd">
	<gml:boundedBy>
		<gml:Envelope srsDimension="3" srsName="urn:ogc:def:crs:EPSG:25832, crs:EPSG:5783">
			<gml:lowerCorner srsDimension="3">458868 5438343 112 </gml:lowerCorner>
			<gml:upperCorner srsDimension="3">458892 5438362 117 </gml:upperCorner>
		</gml:Envelope>
	</gml:boundedBy>
	<cityObjectMember>
		<bldg:Building gml:id="GML_7b1a5a6f-ddad-4c3d-a507-3eb9ee0a8e68">
			<gml:name>Example Building LOD1 and LOD2 with Appearance </gml:name>
			<bldg:function codeSpace="http://www.sig3d.org/codelists/building/1.0/_AbstractBuilding_function.xml">1000</bldg:function>
			<bldg:yearOfConstruction>1985</bldg:yearOfConstruction>
			<bldg:roofType codeSpace="http://www.sig3d.org/codelists/building/1.0/_AbstractBuilding_roofType.xml">1030</bldg:roofType>
			<bldg:measuredHeight uom="#m">5.0</bldg:measuredHeight>
			<bldg:storeysAboveGround>1</bldg:storeysAboveGround>
			<bldg:storeyHeightsAboveGround uom="#m">3.0</bldg:storeyHeightsAboveGround>
			<bldg:lod1Solid>
				<gml:Solid>
					<gml:exterior>
						<gml:CompositeSurface gml:id="lod1Surface">
							<gml:surfaceMember>
								<gml:Polygon>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438350 112 458885 5438350 112 458885 5438350 116 458875 5438350 116
												458875 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458885 5438350 112 458885 5438355 112 458885 5438355 116 458885 5438350 116
												458885 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458885 5438355 112 458875 5438355 112 458875 5438355 116 458885 5438355 116
												458885 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438355 112 458875 5438350 112 458875 5438350 116 458875 5438355 116
												458875 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon gml:id="lod1RoofPoly1">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438350 116 458885 5438350 116 458885 5438355 116 458875 5438355 116
												458875 5438350 116 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438350 112 458875 5438355 112 458885 5438355 112 458885 5438350 112
												458875 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:CompositeSurface>
					</gml:exterior>
				</gml:Solid>
			</bldg:lod1Solid>
			<bldg:lod2Solid>
				<gml:Solid>
					<gml:exterior>
						<gml:CompositeSurface>
							<gml:surfaceMember>
								<gml:CompositeSurface gml:id="fLeft">
									<gml:surfaceMember>
										<gml:Polygon>
											<gml:exterior>
												<gml:LinearRing gml:id="fLeftExt1">
													<gml:posList srsDimension="3">458875 5438350 112 458880 5438350 112 458880 5438350 115 458875 5438350
														115 458875 5438350 112 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon>
											<gml:exterior>
												<gml:LinearRing gml:id="fLeftExt2">
													<gml:posList srsDimension="3">458880 5438350 112 458885 5438350 112 458885 5438350 115 458880 5438350
														115 458880 5438350 112 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:CompositeSurface>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon gml:id="fFront">
									<gml:exterior>
										<gml:LinearRing gml:id="fFrontExt">
											<gml:posList srsDimension="3">458885 5438350 112 458885 5438355 112 458885 5438355 115 458885 5438352.5 117
												458885 5438350 115 458885 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon gml:id="fRight">
									<gml:exterior>
										<gml:LinearRing gml:id="fRightExt">
											<gml:posList srsDimension="3">458885 5438355 112 458875 5438355 112 458875 5438355 115 458885 5438355 115
												458885 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon gml:id="fBack">
									<gml:exterior>
										<gml:LinearRing gml:id="fBackExt">
											<gml:posList srsDimension="3">458875 5438355 112 458875 5438350 112 458875 5438350 115 458875 5438352.5 117
												458875 5438355 115 458875 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon gml:id="lod2RoofPoly1">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438350 115 458885 5438350 115 458885 5438352.5 117 458875 5438352.5
												117 458875 5438350 115 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon gml:id="lod2RoofPoly2">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458885 5438355 115 458875 5438355 115 458875 5438352.5 117 458885 5438352.5
												117 458885 5438355 115 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<gml:surfaceMember>
								<gml:Polygon>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438350 112 458875 5438355 112 458885 5438355 112 458885 5438350 112
												458875 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:CompositeSurface>
					</gml:exterior>
				</gml:Solid>
			</bldg:lod2Solid>
			<bldg:address>
				<Address>
					<xalAddress>
						<xAL:AddressDetails>
							<xAL:Country>
								<xAL:CountryName>Germany</xAL:CountryName>
								<xAL:Locality Type="Town">
									<xAL:LocalityName>Eggenstein-Leopoldshafen</xAL:LocalityName>
									<xAL:Thoroughfare Type="Street">
										<xAL:ThoroughfareNumber>1</xAL:ThoroughfareNumber>
										<xAL:ThoroughfareName>Hermann-von-Helmholtz-Platz</xAL:ThoroughfareName>
									</xAL:Thoroughfare>
									<xAL:PostalCode>
										<xAL:PostalCodeNumber>76344</xAL:PostalCodeNumber>
									</xAL:PostalCode>
								</xAL:Locality>
							</xAL:Country>
						</xAL:AddressDetails>
					</xalAddress>
					<multiPoint>
						<gml:MultiPoint>
							<gml:pointMember>
								<gml:Point>
									<gml:pos srsDimension="3">458880.0 5438352.6 112.0 </gml:pos>
								</gml:Point>
							</gml:pointMember>
						</gml:MultiPoint>
					</multiPoint>
				</Address>
			</bldg:address>
		</bldg:Building>
	</cityObjectMember>
	<cityObjectMember>
		<dem:ReliefFeature gml:id="GML_6bb30328-7599-4500-90ef-766fde6aa67b">
			<dem:lod>1</dem:lod>
			<dem:reliefComponent>
				<dem:TINRelief gml:id="GML_4eb161b0-aa7e-4087-937c-5c4c427c7fc9">
					<gml:name>Ground</gml:name>
					<dem:lod>1</dem:lod>
					<dem:tin>
						<gml:TriangulatedSurface gml:id="ground">
							<gml:trianglePatches>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438362 112 458875 5438355 112 458883 5438362 114 458868 5438362 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458875 5438355 112 458885 5438355 112 458883 5438362 114 458875 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458883 5438362 114 458885 5438355 112 458892 5438362 112 458883 5438362 114 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458885 5438355 112 458885 5438350 112 458892 5438362 112 458885 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458885 5438350 112 458892 5438343 112 458892 5438362 112 458885 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458875 5438350 112 458892 5438343 112 458885 5438350 112 458875 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438343 112 458892 5438343 112 458875 5438350 112 458868 5438343 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438343 112 458875 5438350 112 458875 5438355 112 458868 5438343 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438343 112 458875 5438355 112 458868 5438362 112 458868 5438343 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
							</gml:trianglePatches>
						</gml:TriangulatedSurface>
					</dem:tin>
				</dem:TINRelief>
			</dem:reliefComponent>
		</dem:ReliefFeature>
	</cityObjectMember>
	<app:appearanceMember>
		<app:Appearance>
			<app:theme>Summer</app:theme>
			<app:surfaceDataMember>
				<app:X3DMaterial gml:id="lod1Material">
					<app:diffuseColor>1.0 0.6 0.0</app:diffuseColor>
					<app:target>#lod1Surface</app:target>
				</app:X3DMaterial>
			</app:surfaceDataMember>
			<app:surfaceDataMember>
				<app:GeoreferencedTexture>
					<app:imageURI>ground_summer.png</app:imageURI>
					<app:wrapMode>none</app:wrapMode>
					<app:referencePoint>
						<gml:Point>
							<gml:pos>458870 5438360 NaN </gml:pos>
						</gml:Point>
					</app:referencePoint>
					<app:orientation>0.05 0.0 0.0 -0.05</app:orientation>
					<app:target>#ground</app:target>
					<app:target>#lod1RoofPoly1</app:target>
					<app:target>#lod2RoofPoly1</app:target>
					<app:target>#lod2RoofPoly2</app:target>
				</app:GeoreferencedTexture>
			</app:surfaceDataMember>
			<app:surfaceDataMember>
				<app:ParameterizedTexture gml:id="sideTexture">
					<app:imageURI>facade.png</app:imageURI>
					<app:wrapMode>wrap</app:wrapMode>
					<app:target uri="#fLeft">
						<app:TexCoordList>
							<app:textureCoordinates ring="#fLeftExt1">0.0 0.0 2.0 0.0 2.0 1.0 0.0 1.0 0.0 0.0</app:textureCoordinates>
							<app:textureCoordinates ring="#fLeftExt2">2.0 0.0 4.0 0.0 4.0 1.0 2.0 1.0 2.0 0.0</app:textureCoordinates>
						</app:TexCoordList>
					</app:target>
					<app:target uri="#fRight">
						<app:TexCoordGen>
							<app:worldToTexture>-0.4 0.0 0.0 183550.0 0.0 0.0 0.3333 -37.3333 0.0 0.0 0.0 1.0</app:worldToTexture>
						</app:TexCoordGen>
					</app:target>
				</app:ParameterizedTexture>
			</app:surfaceDataMember>
			<app:surfaceDataMember>
				<app:ParameterizedTexture>
					<app:imageURI>front_back_summer.png</app:imageURI>
					<app:wrapMode>none</app:wrapMode>
					<app:target uri="#fFront">
						<app:TexCoordList gml:id="frontTexCoord">
							<app:textureCoordinates ring="#fFrontExt">0.0 0.0 0.5 0.0 0.5 0.6 0.25 1.0 0.0 0.6 0.0 0.0</app:textureCoordinates>
						</app:TexCoordList>
					</app:target>
					<app:target uri="#fBack">
						<app:TexCoordList gml:id="backTexCoord">
							<app:textureCoordinates ring="#fBackExt">0.5 0.0 1.0 0.0 1.0 0.6 0.75 1.0 0.5 0.6 0.5 0.0</app:textureCoordinates>
						</app:TexCoordList>
					</app:target>
				</app:ParameterizedTexture>
			</app:surfaceDataMember>
		</app:Appearance>
	</app:appearanceMember>
	<app:appearanceMember>
		<app:Appearance>
			<app:theme>Winter</app:theme>
			<app:surfaceDataMember>
				<app:GeoreferencedTexture>
					<app:imageURI>ground_winter.png</app:imageURI>
					<app:wrapMode>none</app:wrapMode>
					<app:referencePoint>
						<gml:Point>
							<gml:pos>458870 5438360 NaN </gml:pos>
						</gml:Point>
					</app:referencePoint>
					<app:orientation>0.05 0.0 0.0 -0.05</app:orientation>
					<app:target>#ground</app:target>
					<app:target>#lod1RoofPoly1</app:target>
					<app:target>#lod2RoofPoly1</app:target>
					<app:target>#lod2RoofPoly2</app:target>
				</app:GeoreferencedTexture>
			</app:surfaceDataMember>
			<app:surfaceDataMember xlink:href="#lod1Material"/>
			<app:surfaceDataMember xlink:href="#sideTexture"/>
			<app:surfaceDataMember>
				<app:ParameterizedTexture>
					<app:imageURI>front_back_winter.png</app:imageURI>
					<app:wrapMode>none</app:wrapMode>
					<app:target uri="#fFront" xlink:href="#frontTexCoord"/>
					<app:target uri="#fBack" xlink:href="#backTexCoord"/>
				</app:ParameterizedTexture>
			</app:surfaceDataMember>
		</app:Appearance>
	</app:appearanceMember>
</CityModel>
