#!/bin/sh

A64="a64.cubewerx.com"
SERVICE="http://$A64/ows3/cubeserv/cubeserv-150k.cgi?service=WFS&datastore=OWS3_VMAP0"
GET_DATA="$SERVICE&REQUEST=GetFeature"
GET_SCHEMA="$SERVICE&REQUEST=DescribeFeatureType"
TIME='/usr/bin/time'

LAYERS='builtupa inwatera elevp elevp_dbl watrcrsl watrcrsl_dbl contourl'

rm -rf data.old
mv -f data data.old
mkdir -p data

# run through layers
for LAYER in $LAYERS; do

    # test network
    echo '%%% processing layer '$LAYER
    echo
    date
    ping -c 4 "$A64"
    [ $? -ne 0 ] && exit 1
    echo 'bulk transfer:'
    $TIME cwcat -ro -t 'http://'$A64'/ows3/simfs/bulk_test_file.bin'
    [ $? -ne 0 ] && exit 1
    echo

    # determine plotting-window parameters
    if [ $LAYER = 'contourl' ]; then
        PLOT_PARAMS='-w 3600 -h 1800 -window=-180,-90,180,90'
        REPEATS='1'
    else
        PLOT_PARAMS='-w 3600 -h 2600 -window=-180,0,-40,90'
        REPEATS='1'
    fi
    if [ $LAYER = 'elevp_dbl' -o $LAYER = 'watrcrsl_dbl' ]; then
        DIGITS=16
    else
        DIGITS=7
    fi

    # plot different encodings
    for COMPRESSION in 'none' 'gzip' 'bzip2'; do
        for ENCODING in 'xml' 'bxml'; do
            # do initial fetch of data
            BASENAME='data/'$LAYER'_'$COMPRESSION'_'$ENCODING
            HTTP_PARAMS="&typename=$LAYER&coordPrecision=$DIGITS&outputFormat=GML3L0&outputEncoding=$ENCODING&outputCompression=$COMPRESSION"
            #echo '### initial data fetch of "'$BASENAME'.gml":'
            #$TIME cwcat -ro -t -httpUncompress=no "$GET_DATA$HTTP_PARAMS"
            #[ $? -ne 0 ] && exit 1
            #echo 'initial data fetch of "'$BASENAME'.xsd":'
            #$TIME cwcat -ro -t -httpUncompress=no "$GET_SCHEMA$HTTP_PARAMS"
            #[ $? -ne 0 ] && exit 1
            #echo

            # repeatedly plot data
            for REP in $REPEATS; do
                echo '+++ plot rep='$REP', layer='$LAYER', encoding='$ENCODING', compression='$COMPRESSION
                $TIME cwplot -url "$GET_DATA$HTTP_PARAMS" -driver gml \
                      $PLOT_PARAMS -t -timeSchema -o $BASENAME.png
                [ $? -ne 0 ] && exit 1
                echo
            done
        done
    done
done
