#!/bin/sh

A64="a64.cubewerx.com"
SERVICE="http://$A64/ows3/simfs/simfs-150k.cgi?service=WFS&datastore=OWS3_VMAP0"
GET_DATA="$SERVICE&request=GetFeature"
GET_SCHEMA="$SERVICE&request=DescribeFeatureType"
TIME="/usr/bin/time"

LAYERS='builtupa inwatera elevp elevp_dbl watrcrsl watrcrsl_dbl contourl'

mkdir -p data

# run through layers
for LAYER in $LAYERS; do

    # test network
    echo '%%% processing layer '$LAYER
	echo
	date
    ping -c 4 $A64
    [ $? -ne 0 ] && exit 1
    echo 'bulk transfer:'
    $TIME cwcat -ro -t "http://$A64/ows3/simfs/bulk_test_file.bin"
    [ $? -ne 0 ] && exit 1
    echo

    # determine plotting-window parameters
    if [ $LAYER = 'contourl' ]; then
        PLOT_PARAMS='-w 3600 -h 1800 -window=-180,-90,180,90'
    else
        PLOT_PARAMS='-w 3600 -h 2600 -window=-180,0,-40,90'
    fi

    # plot different encodings
    for COMPRESSION in 'none' 'gzip' 'bzip2'; do
        for ENCODING in 'xml' 'bxml'; do
            # do initial fetch of data
            BASENAME='data/'$LAYER'_'$COMPRESSION'_'$ENCODING
            HTTP_PARAMS="&typename=$LAYER&outputFormat=text/$ENCODING;encoding=$COMPRESSION"
            echo '### initial data fetch of "'$BASENAME'.gml":'
            HTTP_DATA="$GET_DATA$HTTP_PARAMS"
			echo "$HTTP_DATA"
            $TIME cwcat "$HTTP_DATA" -ro -t
            [ $? -ne 0 ] && exit 1
            echo 'initial data fetch of "'$BASENAME'.xsd":'
            $TIME cwcat "$GET_SCHEMA$HTTP_PARAMS" -ro -t
            [ $? -ne 0 ] && exit 1
            echo

            # repeatedly plot data
            for REP in 1 2 3; do
                echo '+++ plot rep='$REP', layer='$LAYER', encoding='$ENCODING', compression='$COMPRESSION
                $TIME cwplot -url "$HTTP_DATA" -driver gml \
                      $PLOT_PARAMS -t -timeSchema -o $BASENAME.png
                [ $? -ne 0 ] && exit 1
				echo
            done
        done
    done
done
