#!/bin/sh

A64="a64.cubewerx.com"
SERVICE="http://$A64/ows3/simfs/simfs-150k.cgi"
GET_DATA="$SERVICE?request=GetFeature"
GET_SCHEMA="$SERVICE?request=DescribeFeatureType"
TIME="/usr/bin/time"

TRIM="false"

LAYERS="MSD3 MSD3_2D AAL015 AAL015_2D LAP030 LAP030_2D PAL015 PAL015_2D"

rm -rf data.old
mv -f data data.old
mkdir -p data

# run through layers
for LAYER in $LAYERS; do

    # test network
    echo '%%% processing layer '$LAYER
    echo
    date
    ping -c 4 "$A64"
    [ $? -ne 0 ] && exit 1
    echo 'bulk transfer:'
    $TIME cwcat -ro -t "http://$A64/ows3/simfs/bulk_test_file.bin"
    [ $? -ne 0 ] && exit 1
    echo

    # determine plotting-window parameters
    PLOT_PARAMS="-w 1024 -h 768 -ows3 -reportLayers=false"
    REPEATS="1 2 3"

    # plot different encodings
    for COMPRESSION in 'none' 'gzip' 'bzip2'; do
        for ENCODING in 'xml' 'bxml'; do
            # do initial fetch of data
            BASENAME='data/'$LAYER'_'$COMPRESSION'_'$ENCODING
            HTTP_PARAMS="&typename=$LAYER&outputFormat=text/$ENCODING;encoding=$COMPRESSION;trimSchema=$TRIM"
            echo '### initial data fetch of "'$BASENAME'.gml":'
            $TIME cwcat -ro -t -httpUncompress=no "$GET_DATA$HTTP_PARAMS"
            [ $? -ne 0 ] && exit 1
            echo 'initial schema fetch of "'$BASENAME'.xsd":'
            $TIME cwcat -ro -t -httpUncompress=no "$GET_SCHEMA$HTTP_PARAMS"
            [ $? -ne 0 ] && exit 1
            echo

            # repeatedly plot data
            for REP in $REPEATS; do
                echo '+++ plot rep='$REP', layer='$LAYER', encoding='$ENCODING', compression='$COMPRESSION
                $TIME cwplot -url "$GET_DATA$HTTP_PARAMS" -driver gml \
                      $PLOT_PARAMS -t -timeSchema -o $BASENAME.png
                [ $? -ne 0 ] && exit 1
                echo
            done
        done
    done
done
