#!/bin/sh

PRE=''  #'time'

DEST_PARAMS='' #'-gmldigits 7'

SRC_PARAMS='-ows3 -copyFids -reportLayers=false' #'-nfeatures 200000'

REPEATS='1 2 3 4'

for LAYER in AAL015 AAL015_2D LAP030 LAP030_2D PAL015 PAL015_2D MSD3 MSD3_2D
do
	echo "%%% layer: $LAYER"
	for COMPRESSION in none gzip bzip2
	do
		for ENCODING in pack bxml
		do
            SRC=$LAYER'.gml'
            OUT='z_'$LAYER'_'$COMPRESSION'_'$ENCODING'.gml'
            SCHEMA='MSD3_'$COMPRESSION'_'$ENCODING'.xsd'
            FMT="-$ENCODING -$COMPRESSION"
            echo "+++ writing: $OUT"
            for REPEAT in $REPEATS
            do
                $PRE cwdump copy -url $SRC $SRC_PARAMS \
                     -o $OUT $FMT -gml.schema $SCHEMA $DEST_PARAMS -time
                [ $? -ne 0 ] && exit 1
            done

            echo "+++ reading: $OUT"
            for REPEAT in $REPEATS
            do
                $PRE cwdump read -url $OUT $SRC_PARAMS -time
                [ $? -ne 0 ] && exit 1
            done
        done
    done
done
